***********************************************************************
*** Figure 5: Marginal effects of house price and credit exuberance ***
***********************************************************************

clear all
use "$dataPath\Data"
do "$codePath\Transforming_variables"
cd "$outputFigures"

regress global_credit_gap pcredit_gdp_gap
predict interak1, res

regress global_hp_gap hp_inc_gap
predict interak2, res

replace global_credit_gap = interak1
replace global_hp_gap = interak2											   

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap wholesale_gap equity_assets global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id, robust cluster(period)
margins, dydx(ind_hp_inc_exu) at(hcredit_gdp_gap = (-0.1(0.04)0.1))
marginsplot, yline(0, lc(black) lp(dash)) graphregion(color(white)) plotregion(lcolor(black) lpattern(solid)) ///
			 title("") xtitle(Household credit to GDP gap) ytitle("Marginal effects of being in a state of exuberance") ///
			 xlabel(, nogrid tposition(inside)) plotopts(lcolor("221 34 45") mcolor("221 34 45")) ciopts(lcolor("44 115 153")) level(90) ///
			 ylabel(, nogrid) yscale(range(0 0.4)) ylabel(0(0.1)0.4) title("") 
graph export exub_hp_margins.pdf, replace

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap wholesale_gap equity_assets global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id, robust cluster(period)
margins, dydx(ind_credit_gdp_exu) at(hcredit_gdp_gap = (-0.1(0.04)0.1)) 
marginsplot, yline(0, lc(black) lp(dash)) graphregion(color(white)) plotregion(lcolor(black) lpattern(solid)) ///
			 title("") xtitle(Household credit to GDP gap) ytitle("Marginal effect of being in a state of exuberance") ///
			 xlabel(, nogrid tposition(inside)) plotopts(lcolor("221 34 45") mcolor("221 34 45")) ciopts(lcolor("44 115 153")) level(90) ///
			 ylabel(, nogrid) yscale(range(0 0.4)) ylabel(0(0.1)0.4) title("")
graph export exub_credit_margins.pdf, replace	
